// Scilab : 6.0.0
// OS: Windows 7, 64 bit
// Lab 3 a): To Check the Controllability of given system by Gilbert's Test

clc ;
clear all;

// Let the system is described by state equations
A=[0,1,0;0,0,1;-6,-11,-6];
B=[0;0;1];
// Solution: -
// Gilbert's Test is required to find canonical state variable form as -
// Given system is in Phase Variable form, therefore Vander Monde Matrix is 
// required as an Modal Matrix
// Find the eigenvalues and eigenvectors of matrix A
[V,D]=spec(A);
// Forming the Vander Monde Matrix from the eigenvalues as -
d = diag(D); dd=(d.^2);
M=[1,1,1;d';dd'];
Minv=inv(M);
// Finding the Bcap 
Bcap=Minv*B;
disp(Bcap,"Bcap")
// Check the contents of B vector, whether any element is zero, 
// if not then system is controllable
// Result
 
// Bcap
//
//   0.5  
//  -1.  
//   0.5  
